'PIO assembler - 027

'** Ref info for development only **
'PIO(PINCTRL no_side_set_pins [,no_set_pins] [,no_out_pins] [,IN base] [,side_set_base] [,set_base])
'PIO(EXECCTRL jmp_pin ,wrap_target, wrap
'PIO(SHIFTCTRL push_threshold [,pull_threshold] [,autopush] [,autopull])
'PIO INIT MACHINE pio, statemachine, clockspeed, PINCTRL register, EXECCTRL register,
' SHIFTCTRL register

Option explicit

Dim pio1%(7)  'output array - unused area is paded with nop statements (&hA042).
Dim op(31)    'op() is for development only (to simplify viewing). Don't use this.
Dim p,d$,db1$,dv
Dim integer ecwt,ecw 'storage for .wrap target and .wrap - will be removed eventually.
Dim integer PINCTRL(3),EXECCTRL(3),SHIFTCTRL(3)  'global RP2040 registers for machines 0-3
Dim integer machine=0


'Note:
'Delimiters between parts of the commands can be a single space or a single comma.
'Multiple delimiters are not supported and those instructions will not assemble correctly.
'Data to be assembled must finish with a null data string i.e. DATA ""

'Directives - :word <word> / .wrap target / .wrap
'Pseudoinstructions - .nop (mov y,y)

' .wrap target and .wrap are currently stored in variables, but RP2040 registers
' aren't implmented yet

'to run samples change restore points at the end of the data statements *and* in
'the display sub at the end.


sample1:
Data "pull noblock side 0","mov x, osr","mov y, isr","jmp x!=y 5","jmp 6 side 1"
Data "nop","jmp y-- 3",""

sample2:
Data "set pindirs,0 side 0 [7]","set pindirs,1 side 0 [7]"
Data "set pindirs,0 side 1 [7]","set pindirs,1 side 1 [7]",""

sample3:
Data "jmp y-- 12"
Data "irq wait 0 rel"
Data "set x,7"
Data "out pindirs,1 [7]"
Data "nop side 1 [2]"
Data "wait 1 pin 1 [4]"
Data "in pins,1 [7]"
Data "jmp x--,3 side 0 [7]"
Data "out pindirs,1 [7]"
Data "nop side 1 [7]"
Data "wait 1 pin,1 [7]"
Data "jmp pin 0 side 0 [2]"
Data ".wrap target"
Data "out x,6"
Data "out y 1"
Data "jmp !x 2"
Data "out null,32"
Data "out exec, 16"
Data "jmp x-- 16"
Data ".wrap"
Data ""

sample4:
Data "out x,1 side 1"
Data "jmp !x,3 [6]"
Data "jmp 0 side 0 [7]"
Data "jmp 4 [7]"
Data "out x,1 side 0"
Data "jmp !x,7 [6]"
Data "jmp 4 side 1 [7]"
Data "jmp 0,[7]"
Data ""

sample5:
Data "wait 1 pin 0 [11]"
Data "jmp pin,4"
Data "in x,1"
Data "jmp 0"
Data "in y,1 [1]"
Data ".wrap target"
Data "wait 0 pin,0 [11]"
Data "jmp pin,9"
Data "in y,1"
Data "jmp 0"
Data "in x,1 [1]"
Data ".wrap"
Data ""

sample6:   'problem with this sample. Why is bit 12 not set on official assembler?
Data ".wrap target"
Data "pull block side 0"
Data "in osr,1 side 0"
Data "out null,8 side 0"
Data "in osr,1 side 0"
Data "out null,8 side 0"
Data "in osr,1 side 0"
Data "out null,32 side 0"
Data "pull block side 0"
Data "in osr,1 side 1"
Data "out null,8 side 1"
Data "in osr,1 side 1"
Data "out null,8 side 1"
Data "in osr,1 side 1"
Data "out null,32 side 1"
Data "in null,26 side 1"
Data "pull block side 1"
Data "mov pins :: isr side 1"
Data ".wrap"
Data ""

sample7:
Data ".wrap target"
Data "pull ifempty block"
Data "set x,2"
Data "in osr,5"
Data "out null,5"
Data "in null,3"
Data "jmp x--,2"
Data "in y,8"
Data "mov isr :: isr"
Data "out nul,1"
Data "set x,31"
Data "set pins,0"
Data "mov pins,isr [6]"
Data "set pins,1"
Data "in isr,1 [6]"
Data "jmp x--,10"
Data ".wrap"
Data ""

sample8:
Data ".wrap target"
Data "pull block"
Data "mov x ! osr"
Data "pull block"
Data "mov y,osr"
Data "jmp 6"
Data "jmp x--,6"
Data "jmp y--,5"
Data "mov isr ! x"
Data "push block"
Data ".wrap"
Data ""

sample9:
Data "wait 1 pin,0 [11]"
Data "jmp pin,4"
Data "in x,1"
Data "jmp 0"
Data "in y,1 [1]"
Data ".wrap target"
Data "wait 0 pin,0 [11]"
Data "jmp pin,9"
Data "in y,1"
Data "jmp 0"
Data "in x,1 [1]"
Data ".wrap"
Data ""

sample10:
Data ".wrap target"
Data "out x,1 side 1"
Data "jmp !x,3 [6]"
Data "jmp 0 side 0 [7]"
Data "jmp 4 [7]"
Data "out x,1 side 0"
Data "jmp !x,7 [6]"
Data "jmp 4 side 1 [7]"
Data "jmp 0 [7]"
Data ".wrap"
Data ""

samplex:
Data "nop side 1 [7]"
Data ""


Restore sample3  '**** change this ****
PASM pio1%(),0   'output array, state machine


display


'----------------- SUBROUTINES -------------------------
Sub PASM(array%(),machine)
  Local info$="** RP2040 PIO ASSEMBLER - The Backshed Forum - Mixtel90"
  Local i,j,d$,ac=0,av=0,nf=1
  Local c$',c1$
  store array%(),-1   'reset the store array
  Do                  'start to process the program
    Read d$           'read the data statement
    If d$="" Then Exit
    c$=argn$(d$,1)    'reset function and get first argument / command
    Select Case c$    'and do something with it
      Case "//"
        'just a comment
'.wrap-------------------
      Case ".wrap"
        c$=argn$(d$)
        If c$>"" Then
          ecwt = ac          'wrap target
          Inc ac,-1
        Else
          ecw = ac-1         'wrap - loop to wrap target
          Inc ac,-1
        EndIf
':word-----------------
      Case ":word"
        c$=argn$(d$)
        av=Val(c$)           'insert a 16-bit data word
'nop-------------------
      Case "nop"
        av=&hA042            'use mov y,y as a nop
'jmp--------------------
      Case "jmp"
        av=0
        c$=argn$(d$)         'get the first argument
          i=Instr("  !x x--!y y--x!=pin!os",Left$(c$,3))
        If i>0 And c$<>"0" Then  'this must be a conditional jump
          i=i/3
          av=av+((i)<<5)     'add the condition to av
          c$=argn$(d$)       'get the destination argument
          av=av+Val(c$)      'and add it to av
        Else                 'no condition so must be a direct destination
          av=av+Val(c$)      'so add it to av
        EndIf
'wait---------------------
      Case "wait"
        c$=argn$(d$)         'get polarity bit argument
        av=(1<<13)+Val(c$)*128    'and add it
        c$=argn$(d$)         'get condition argument
        i=Instr("  gpipinirq",Left$(c$,3))
        i=i/3
        av=av+((i-1)<<5)     'add the condition to av
        c$=argn$(d$)          'get the index value
        av=av+Val(c$)        'add it to av
'in---------------------
      Case "in"
        av=2<<13
        c$=argn$(d$)         'get source
        i=Instr("  pinx  y  nul      isrosr",Left$(c$,3))
        If i>0 Then
          i=i/3
          av=av+((i-1)<<5)   'and add it
        EndIf
        c$=argn$(d$)         'get the index value
        av=av+Val(c$)        'add it to av
'out-----------------------
      Case "out"
        av=3<<13
        c$=argn$(d$)          'get source
        i=Instr("   pinsx   y   nullpindpc  isr exec",Left$(c$,4))
        i=i/4                 'will have a value of 1 for "pins"
        av=av+((i-1)<<5)      '"pins"= destination 0, so subtract 1
        c$=argn$(d$)          'get the index value
        i=Val(c$)
        If i>31 Then i=0      'trap 32 so we don't overwrite the destination bits
        av=av+i               'add it to av
'push----------------------
      Case "push"
        av=(4<<13)+32         'iffull not set and block set by default so "block" does nothing
        If c$="iffull" Then av=av+64
        If c$="noblock" Then av=av-32
'pull--------------------
      Case "pull"
        av=(4<<13)+128+32
        c$=argn$(d$)
        If c$="ifempty" Then av=av+64
        If c$="noblock" Then av=av-32
'mov----------------------
      Case "mov"
        av=(5<<13)
        c$=argn$(d$)         'get destination argument
        i=Instr("  pinx  y     exepc isrosr",Left$(c$,3))  'destination
        i=i/3
        av=av+((i-1)<<5)     'and add it to av
        c$=argn$(d$)         'get condition or source argument
        If c$="!" Or c$="-" Then av=av+8:c$=argn$(d$) '! or - condition
        If c$="::" Then av=av+16:c$=argn$(d$)         ':: condition
        i=Instr("  pinx  y  nul   staisrosr",Left$(c$,3))  'source
        i=i/3
        av=av+(i-1)          'add source to av
'irq-----------------------------
      Case "irq"
        av=(6<<13)
        i=Instr(d$,"rel")    'i is set if irq number to be calculated from state machine#
        If i>0 Then av=av+16 'set rel flag (MSB of irq index)
        c$=argn$(d$)         'get first argument
        Select Case c$
          Case "set","nowait"'set the irq without waiting
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case "wait"
            av=av+32         'set the wait bit
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case "clear"
            av=av+64         'set the clear bit. The wait bit is ignored
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case Else
            j=av+Val(c$)     'it must be just an irq number - save it
        End Select
        If i>0 Then          'it's rel irq
          av=av+((j+machine) Mod 4) 'add the rel index
        Else
          av=av+j            'it's not rel, so just add the index
        EndIf
'set----------------------
      Case "set"
        av=7<<13
        c$=argn$(d$)
        Select Case c$
          Case "pins":av=av+0
          Case "x":av=av+(1<<5)
          Case "y":av=av+(2<<5)
          Case "pindirs":av=av+(4<<5)
        End Select
        c$=argn$(d$)          'get the data
        av=av+Val(c$)         'add it to av
'---------------------
    End Select
    c$=argn$(d$)                     'get next argument
    If ac>=0 Then
      If c$="side" Then              'look for "side" argument
        c$=argn$(d$)                 'if we find it then find which side & install it
        If c$="0" Then av=av+(&b10<<11)
        If c$="1" Then av=av+(&b11<<11)
        c$=argn$(d$)
      EndIf
      If Left$(c$,1)="[" Then        'look for delay argument
        i=Instr(c$,"]")
        dv=Val(Mid$(c$,2,Len(c$)-2)) 'extract the value from between the brackets
        av=av+(dv<<8)                'and install it
      EndIf
      op(ac)=av                      'store in development array
      store array%(),av              'pack into output array
    EndIf
    Inc ac                           'loop back for the next program statement
  Loop
End Sub


'return the next argument$ in d$ or null$ if none found
'delimited by a comma or a space
Function argn$(d$,r)
Local a$
  Static n=1
  If r=1 Then n=1                    'if r is present and is -1 then reset (overkill)
  argn$=Field$(d$,n," , ")           'get argument from position n to delimiter
  If argn$="" Then n=1:Exit Function 'reset n if we got to end of d$ (null string)
  n=n+1
End Function


'pack the 16-bit instruction into 64-bit integers
Sub store(array%(),instruction%)
  Static integer word=0, element=0
  Local i
  If instruction%=-1 Then
    For i=0 To 31
      store array%(),&hA042
    Next
    word=0:element=0:Exit Sub
  EndIf
  array%(element)=array%(element)+(instruction%<<word)
  word=word+16
  If word>50 Then element=element+1:word=0
End Sub


'display the output
Sub display
  Local p,l,x
  Print
  Restore sample3  '**** CHANGE THIS ****
  p=0:l=0
  Do
    Read d$
    If d$="" Then Exit
    If Left$(d$,1)="." Then
      Select Case d$
        Case ".wrap target":Print ,,d$" = "ecwt
        Case ".wrap":Print ,,d$" = "ecw
      End Select
    Else
      Print "0x"Hex$(op(p),4)" // "Str$(l,2)": "Left$(d$+Space$(26),25),Bin$(op(p),16)
      Inc p:Inc l
      End Select
    EndIf
  Loop

'  Print                        'uncomment 4 lines to show the packed data
'  For p=0 To 7
'  Print p": "Bin$(pio1%(p),64)" : "Hex$(pio1%(p),16)
'  Next
End Sub               